#include <iostream>
#include <vector>
#include <algorithm>

std::vector<int> constructQ(const std::vector<int>& P) {
    int N = P.size() - 1;
    std::vector<int> Q(N + 1, 0);

    std::vector<int> sortedP = P;
    std::sort(sortedP.rbegin(), sortedP.rend());

    for (int i = 0; i <= N; ++i) {
        Q[i] = sortedP[i] ^ P[i];
    }

    return Q;
}

int main() {
    int N;
    std::cout << "Unesite duzinu niza P: ";
    std::cin >> N;

    std::vector<int> P(N + 1);
    std::cout << "Unesite elemente niza P: ";
    for (int i = 0; i <= N; ++i) {
        std::cin >> P[i];
    }

    std::vector<int> Q = constructQ(P);

    std::cout << "Najveci moguci X: ";
    int maxX = 0;
    for (int i = 0; i <= N; ++i) {
        maxX += P[i] ^ Q[i];
    }
    std::cout << maxX << std::endl;

    std::cout << "Niz Q: ";
    for (int i = 0; i <= N; ++i) {
        std::cout << Q[i] << " ";
    }

    return 0;
}